% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirichlet-distribution.R
\name{Dirichlet}
\alias{Dirichlet}
\alias{ddirichlet}
\alias{rdirichlet}
\title{Dirichlet distribution}
\usage{
ddirichlet(x, alpha, log = FALSE)

rdirichlet(n, alpha)
}
\arguments{
\item{x}{\eqn{k}-column matrix of quantiles.}

\item{alpha}{\eqn{k}-values vector or \eqn{k}-column matrix;
concentration parameter. Must be positive.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density function, cumulative distribution function and random generation
for the Dirichlet distribution.
}
\details{
Probability density function
\deqn{
f(x) = \frac{\Gamma(\sum_k \alpha_k)}{\prod_k \Gamma(\alpha_k)} \prod_k x_k^{k-1}
}{
f(x) = \Gamma(sum(\alpha[k])) / prod(\Gamma(\alpha[k])) * prod(x[k]^{k-1})
}
}
\examples{

# Generating 10 random draws from Dirichlet distribution
# parametrized using a vector

rdirichlet(10, c(1, 1, 1, 1))

# or parametrized using a matrix where each row
# is a vector of parameters

alpha <- matrix(c(1, 1, 1, 1:3, 7:9), ncol = 3, byrow = TRUE)
rdirichlet(10, alpha)

}
\references{
Devroye, L. (1986). Non-Uniform Random Variate Generation. Springer-Verlag.
}
\keyword{distribution}
