% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exact_twoway_anova_power.R
\name{exact_twoway_anova_power}
\alias{exact_twoway_anova_power}
\title{Two-way factorial ANOVA exact sample size calculation for independent samples}
\usage{
exact_twoway_anova_power(
  a,
  b,
  effect_sizes,
  n,
  alpha = 0.05,
  factor_names = NULL,
  plot = TRUE,
  title = NULL,
  target_power = NULL,
  target_line = TRUE,
  alpha_line = TRUE
)
}
\arguments{
\item{a}{Number of levels of the first factor}

\item{b}{Number of levels of the second factor}

\item{effect_sizes}{Numeric vector of length 3. The first two elements are the effect sizes for the main effects of the first
and second factors, respectively. The third element is the interaction effect size.}

\item{n}{Number of experimental units in each group for which power (1-beta) will be calculated.}

\item{alpha}{numeric - Type I error probability. Defaults to 0.05}

\item{factor_names}{character - vector of length 2. Names of the 2 factors to be evaluated. Default is to inherit names
from effect_sizes. If effect_sizes has no names and no factor_names are provided, factors will be named 'FactorA' and
'FactorB'.}

\item{plot}{logical - Should the power curve be plotted. Default is TRUE.}

\item{title}{character - Title for the graph. Defaults to 'Power curve from exact ANOVA test'}

\item{target_power}{numeric - Desired power to be attained. Accepts values between 0 and 1, defaults to 0.8.}

\item{target_line}{logical - Set to TRUE. If FALSE no target line will be drawn. Overrides target_power.}

\item{alpha_line}{logical - Should a line at the set type I error be plotted}
}
\value{
A list that contains the number of levels for each factor, the chosen significance level and a data.frame in which the
first column is the group sample size and the remaining three columns are the power for the main effect of the first
factor, the main effect of the second factor and their interaction, respectively.

Optionally, a graph that displays the power curves.
}
\description{
This functions takes the effect sizes (Cohen's f) for two main effects and their interaction and estimates power
a range of sample sizes. The input for this function can be generated by \code{effsize}.
}
\details{
Probably the best way to calculate power for independent balanced designs
}
\examples{
refmean <- 1
treatgroups <- 4
timepoints <- 5
treateff <- 1.25
timeeff <- 0.85
cellswithinteraction <- matrix(c(rep(2,3), 3:5), 3,2)
#second level of factor A interacts with 3rd, 4th and 5th level of factor B

factors_levels_names <- list(treatment=letters[1:treatgroups], time=1:timepoints)

effects_treat_time_interact <- calculate_mean_matrix(refmean = refmean,
                                                     nlfA = treatgroups, nlfB = timepoints,
                                                     fAeffect = treateff, fBeffect = timeeff,
                                                     label_list = factors_levels_names,
                                                     groupswinteraction = cellswithinteraction,
                                                     interact=1.3)

fxs <- effsize(effects_treat_time_interact)
exact_twoway_anova_power(a= treatgroups, b=timepoints, effect_sizes=fxs, n=5:20)

}
