/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class AbstractTrees<E> {
    ArrayList<E> trees;
    int numThreads = 1;

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public ArrayList<E> buildTreesParallel(int n, int n2, int n3) {
        List list;
        ExecutorService executorService = Executors.newFixedThreadPool(this.numThreads);
        ArrayList<TreeCallable> arrayList = new ArrayList<TreeCallable>();
        TreeCallable treeCallable = new TreeCallable(n, n2);
        for (int i = 0; i < n3; ++i) {
            arrayList.add(treeCallable);
        }
        try {
            list = executorService.invokeAll(arrayList);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        ArrayList arrayList2 = new ArrayList(n3);
        for (Future future : list) {
            try {
                arrayList2.add(future.get());
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException);
            }
        }
        executorService.shutdown();
        return arrayList2;
    }

    public ArrayList<E> buildTrees(int n, int n2, int n3) {
        ArrayList<E> arrayList = new ArrayList<E>(n3);
        for (int i = 0; i < n3; ++i) {
            arrayList.add(this.buildTree(n, n2));
        }
        return arrayList;
    }

    public void learnTrees(int n, int n2, int n3) {
        this.trees = this.numThreads < 0 ? this.buildTrees(n, n2, n3) : this.buildTreesParallel(n, n2, n3);
    }

    public abstract E buildTree(int var1, int var2);

    public class TreeCallable
    implements Callable<E> {
        int nmin;
        int K;

        public TreeCallable(int n, int n2) {
            this.nmin = n;
            this.K = n2;
        }

        @Override
        public E call() throws Exception {
            return AbstractTrees.this.buildTree(this.nmin, this.K);
        }
    }
}

