% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timetodayFAERS.R
\name{timetodayFAERS}
\alias{timetodayFAERS}
\alias{time_to_day_FAERS}
\title{Change all time units to days in the data filtered by filter_by_occu_FAERS().
This function converts age and time units in the data to days, and processes occupation and reaction data.}
\usage{
time_to_day_FAERS(workingdir = NULL, usexistRData = FALSE, filteres = NULL)
}
\arguments{
\item{workingdir}{Directory containing \code{F_COREDATA_1PS_PROF.RData}.}

\item{usexistRData}{Logical. Specifies whether to use \code{F_COREDATA_1PS_PROF.RData} in the working directory for calculations.
Must be set to \code{TRUE} and \code{workingdir} must be provided if \code{time_to_day_FAERS} is used independently.}

\item{filteres}{Filtered results for changing time units. Used only when \code{extract1PSFAERS} is called internally.
Set to \code{NULL} if \code{time_to_day_FAERS} is used separately.}
}
\value{
A character vector containing the path of the processed file "F_COREDATA_1PS_PROF_STU.RData", which can be used for further analysis
}
\description{
Change all time units to days in the data filtered by filter_by_occu_FAERS().
This function converts age and time units in the data to days, and processes occupation and reaction data.
}
\details{
This package includes example data files in \code{extdata}:
\itemize{
\item \code{faers_ascii_2015q1_example.zip}: Example dataset 1.
\item \code{faers_ascii_2015q2_example.zip}: Example dataset 2.
\item \code{faers_ascii_2015q3_example.zip}: Example dataset 3.
\item \code{faers_ascii_2015q4_example.zip}: Example dataset 4.
\item Use \code{system.file("extdata",package = "extractFAERS")} to access the folder contain example zip files.
}
}
\examples{
# Example_1 Perform FAERS data preprocessing in one step and
# generate `F_COREDATA_1PS_PROF_STU.RData` in a temporary folder.
# In practice, it is recommended to set `usetempdir = FALSE` and specify `workingdir`
# to prevent the processed results in the temporary folder from being automatically deleted.
extract_FAERS_data(
  workingdir = system.file("extdata", package = "extractFAERS"),
  usetempdir = TRUE,
  corenum = 2,
  startfile = 1,
  endfile = 4,
  onlydoextract = FALSE,
  occpextract = NULL
)

# Example_2 Stepwise FAERS data preprocessing
# Setting `onlydoextract = TRUE` extracts only single-drug cases and organizes file paths.
# The processed file paths are saved in a temporary directory.
extractfaerspath <- extract_FAERS_data(
  workingdir = system.file("extdata", package = "extractFAERS"),
  usetempdir = TRUE,
  corenum = 2,
  startfile = 1,
  endfile = 4,
  onlydoextract = TRUE,
  occpextract = NULL
)
print(extractfaerspath)

# Filter data based on reporter occupation
# By default, only reports from healthcare professionals
# (e.g., physicians, pharmacists) are retained.
faers1psprofdata <- filter_by_occp_FAERS(
  workingdir = extractfaerspath,
  occpextract = NULL,
  savetoRData = TRUE
)

# Standardize time units to days
# This ensures consistency in the dataset and facilitates analysis of adverse reactions
# based on patient age.
time_to_day_FAERS(
workingdir = extractfaerspath,
usexistRData = TRUE,
filteres = NULL
)

}
