% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which.R
\name{logical indexes (which)}
\alias{logical indexes (which)}
\alias{\%?gele\%}
\alias{\%?gel\%}
\alias{\%?gle\%}
\alias{\%?gl\%}
\alias{\%?ge\%}
\alias{\%?g\%}
\alias{\%?le\%}
\alias{\%?l\%}
\alias{\%?in\%}
\alias{\%?!in\%}
\alias{\%?nin\%}
\alias{\%?==\%}
\alias{\%?!=\%}
\alias{\%?c\%}
\alias{\%?e\%}
\title{Several ways to return an index based on logical range comparison helpers}
\usage{
e1 \%?gele\% e2

e1 \%?gel\% e2

e1 \%?gle\% e2

e1 \%?gl\% e2

e1 \%?ge\% e2

e1 \%?g\% e2

e1 \%?le\% e2

e1 \%?l\% e2

e1 \%?in\% e2

e1 \%?!in\% e2

e1 \%?nin\% e2

e1 \%?==\% e2

e1 \%?!=\% e2

e1 \%?c\% e2

e1 \%?e\% e2
}
\arguments{
\item{e1}{A number of vector to be evaluated and for which the indices will be returned}

\item{e2}{A vector of one or two numbers used to denote the
limits for logical comparison.}
}
\value{
A vector of the indices identifying which values of \code{e1} meet the logical conditions.
}
\description{
Several ways to return an index based on logical range comparison helpers
}
\examples{

1:5 \%?gele\% c(2, 4)
1:5 \%?gele\% c(4, 2) # order does not matter uses min / max

1:5 \%?gel\% c(2, 4)
1:5 \%?gel\% c(4, 2) # order does not matter uses min / max

1:5 \%?gle\% c(2, 4)
1:5 \%?gle\% c(4, 2) # order does not matter uses min / max

1:5 \%?gl\% c(2, 4)
1:5 \%?gl\% c(4, 2) # order does not matter uses min / max

1:5 \%?ge\% 2
1:5 \%?ge\% 4

1:5 \%?g\% 2
1:5 \%?g\% 4

1:5 \%?le\% 2
1:5 \%?le\% 4

1:5 \%?l\% 2
1:5 \%?l\% 4

1:5 \%?in\% c(2, 99)
c("jack", "jill", "john", "jane") \%?in\% c("jill", "jane", "bill")

1:5 \%?!in\% c(2, 99)
c("jack", "jill", "john", "jane") \%?!in\% c("jill", "jane", "bill")

1:5 \%?nin\% c(2, 99)
c("jack", "jill", "john", "jane") \%snin\% c("jill", "jane", "bill")

11:15 \%?==\% c(11, 1, 13, 15, 15)

11:15 \%?!=\% c(11, 1, 13, 15, 15)
## define a variable
sample_data <- c(1, 3, 9, 5, NA, -9)

## suppose that we expect that values should fall in [1, 10]
## unless they are special character, -9 used for unknown / refused
sample_data \%?c\% "( >= 1 & <= 10 ) | == -9"

## we might expect some missing values and be OK as long as
## above conditions are met or values are missing
sample_data \%?c\% "( >= 1 & <= 10 ) | == -9 | is.na"

## equally we might be expecting NO missing values
## and want missing values to come up as FALSE
sample_data \%?c\% "(( >= 1 & <= 10 ) | == -9) & !is.na"

## clean up
rm(sample_data)
## define a variable
sample_data <- c(1, 3, 9, 5, -9)

sample_data \%?e\% "(-8, 1] | [2, 9)"

## clean up
rm(sample_data)
}
