% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distLexBoot.R
\name{distLexBoot}
\alias{distLexBoot}
\title{Bootstrapping uncertainty intervals for return periods}
\usage{
distLexBoot(dlf, nbest = 3, selection = NULL, n = 100, prop = 0.8,
  conf.lev = 0.95, RPs = NULL, log = TRUE, progbars = TRUE,
  quiet = FALSE)
}
\arguments{
\item{dlf}{\code{dlf} object, as returned by \code{\link{distLextreme}}}

\item{nbest}{Number of best fitted distribution functions in dlf for which
bootstrapping is to be done. Overridden by \code{selection}. DEFAULT: 3}

\item{selection}{Character vector with distribution function names to be used.
Suggested to keep this low. DEFAULT: NULL}

\item{n}{Number of subsamples to be processed
(computing time increases extraordinarily). DEFAULT: 100}

\item{prop}{Proportion of sample to be used in each run. DEFAULT: 0.8}

\item{conf.lev}{Confidence level (Proportion of subsamples within 'confidence interval').
Quantiles extracted from this value are passed to
\code{\link[berryFunctions]{quantileMean}}. DEFAULT: 0.95}

\item{RPs}{Return Period vector, by default calculated internally based on
value of \code{log}. DEFAULT: NULL}

\item{log}{RPs suitable for plot on a logarithmic axis? DEFAULT: TRUE}

\item{progbars}{Show progress bar for Monte Carlo simulation? DEFAULT: TRUE}

\item{quiet}{Logical: suppress messages? See \code{\link{distLquantile}}.
DEFAULT: FALSE}
}
\value{
invisible dlf object, see \code{\link{printL}}.
Additional elements are: exBootCL (confidence level),
exBootRPs (x values for plot)
exBootSim (all simulation results) and exBootCI (aggregated into CI band).
The last two are each a list with a matrix (return levels)
}
\description{
Calculates and plots bootstrap uncertainty intervals for \code{\link{plotLextreme}}.
}
\details{
Has not been thoroughly tested yet. Bootstrapping defaults can probably be improved.
}
\examples{

data(annMax)
dlf <- distLextreme(annMax, selection=c("wak","gum","gev","nor"))
dlfB <- distLexBoot(dlf, nbest=4, conf.lev=0.5, n=10) # n low for quick example tests
plotLexBoot(dlfB)

}
\seealso{
\code{\link{plotLexBoot}}, \code{\link{distLextreme}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Sept 2015 + Dec 2016
}
\keyword{bootstrap}
\keyword{distribution}
\keyword{dplot}
\keyword{hplot}
\keyword{montecarlo}
\keyword{ts}
