% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{goftest.hill.ts}
\alias{goftest.hill.ts}
\title{Goodness of fit test statistics for time series}
\usage{
\method{goftest}{hill.ts}(object, X, t, plot = FALSE, ...)
}
\arguments{
\item{object}{output of the hill.ts function.}

\item{X}{a vector of the observed values.}

\item{t}{a vector of time covariates which should have the same length as X.}

\item{plot}{If \code{TRUE}, the test statistic are plotted.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\item{TS.window}{the maximum value of test statistics inside the window for each t in Tgrid (see help(hill.ts) ).}
\item{TS.max}{the maximum value of test statistics for each t in Tgrid (see help(hill.ts) ).}
\item{CritVal}{the critical value of the test.}
}
\description{
Give the results of the goodness of fit test for testing the null hypothesis that the tail is fitted by a Pareto distribution starting from the adaptive threshold (for more details see pages 447 and 448 of Durrieu et al. (2015)).
}
\examples{
theta<-function(t){0.5+0.25*sin(2*pi*t)}
n<-5000
t<-1:n/n
Theta<-theta(t)
Data<-NULL
Tgrid<-seq(0.01,0.99,0.01)
#example with fixed bandwidth
for(i in 1:n){Data[i]<-rparetomix(1,a=1/Theta[i],b=5/Theta[i]+5,c=0.75,precision=10^(-5))}
\dontrun{ #For computing time purpose
  #example
  hgrid <- bandwidth.grid(0.009, 0.2, 20, type = "geometric")
  TgridCV <- seq(0.01, 0.99, 0.1)
  hcv <- bandwidth.CV(Data, t, TgridCV, hgrid, pcv = 0.99,
         TruncGauss.kernel, kpar = c(sigma = 1), CritVal = 3.6, plot = TRUE)

  Tgrid <- seq(0.01,0.99,0.01)
  hillTs <- hill.ts(Data, t, Tgrid, h = hcv$h.cv, TruncGauss.kernel, kpar = c(sigma = 1),
                   CritVal = 3.6, gridlen = 100, initprop = 1/10, r1 = 1/4, r2 = 1/20)
  goftest(hillTs, Data, t, plot = TRUE)

  # we observe that for this data, the null hypothesis that the tail
  # is fitted by a Pareto distribution is not rejected
  # for all points on the Tgrid

}


}
\references{
Grama, I. and Spokoiny, V. (2008). Statistics of extremes by oracle estimation. Ann. of Statist., 36, 1619-1648.

Durrieu, G. and Grama, I. and Pham, Q. and Tricot, J.- M (2015). Nonparametric adaptive estimator of extreme conditional tail probabilities quantiles. Extremes, 18, 437-478.
}
\seealso{
\code{\link{hill.ts}}, \code{\link{goftest}}
}

