% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_cyclopean_samples.R
\name{compute_cyclopean_samples}
\alias{compute_cyclopean_samples}
\alias{compute_cyclopean_samples.data.frame}
\alias{compute_cyclopean_samples.eyelinkRecording}
\title{Computes cyclopean samples by averaging over binocular data}
\usage{
compute_cyclopean_samples(object, fun = mean)

\method{compute_cyclopean_samples}{data.frame}(object, fun = mean)

\method{compute_cyclopean_samples}{eyelinkRecording}(object, fun = mean)
}
\arguments{
\item{object}{Either an \code{\link{eyelinkRecording}} object or data.frame with samples,
i.e., \code{samples} slot of the \code{\link{eyelinkRecording}} object.}

\item{fun}{Function used to average across eyes, defaults to \code{\link{mean}}.}
}
\value{
Object of the same time as input, i.e., either a \code{\link{eyelinkRecording}} object
with \emph{modified} \code{samples} slot or a data.frame with cyclopean samples.
}
\description{
Computes cyclopean samples by averaging over binocular recorded properties
such as \code{pxL}/\code{pxR}, \code{pyL}/\code{pyR}, \code{hxL}/\code{hxR},
etc. Uses function specified via \code{fun}
parameter to compute the average with \code{na.rm = TRUE} option.
In case of a monocular recording or when the information from one eye missing,
uses information from one eye only, ignoring the other column.
In both binocular and monocular recording cases, simplifies column names
so that \code{pxL} and/or \code{pxR} are replaced
with a single column \code{px}, \code{pyL}/\code{pyR} with \code{py}, etc.
}
\examples{
data(gaze)

# by passing samples table
cyclopean_samples <- compute_cyclopean_samples(gaze$samples)

# storing cyclopean samples as a separate table in recording
gaze$cyclopean_samples <- compute_cyclopean_samples(gaze$samples)

# by passing the recording, cyclopean samples replace original ones
gaze <- compute_cyclopean_samples(gaze)
}
