% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-database.R
\name{eyeris_db_connect}
\alias{eyeris_db_connect}
\title{Connect to eyeris project database (user-facing)}
\usage{
eyeris_db_connect(bids_dir, db_path = "my-project")
}
\arguments{
\item{bids_dir}{Path to the BIDS directory containing the database}

\item{db_path}{Database name (defaults to "my-project", becomes "my-project.eyerisdb")
If just a filename, will look in \verb{derivatives/} directory.
If includes path, will use as provided.}
}
\value{
Database connection object for use with other eyeris database functions
}
\description{
User-friendly function to connect to an existing \code{eyeris} project database.
This function provides easy access for users to query their \code{eyeris} data.
}
\examples{
\donttest{
# step 1: create a database using bidsify with db_enabled = TRUE
# (This example assumes you have already run bidsify to create a database)

# temp dir for testing
temp_dir <- tempdir()

# step 2: connect to eyeris DB (will fail gracefully if no DB exists)
tryCatch({
  con <- eyeris_db_connect(temp_dir)

  tables <- eyeris_db_list_tables(con)

  # read timeseries data for a specific subject
  data <- eyeris_db_read(con, data_type = "timeseries", subject = "001")

  # close connection when done
  eyeris_db_disconnect(con)
}, error = function(e) {
  message("No eyeris DB found - create one first with bidsify(db_enabled = TRUE)")
})
}

}
