% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/time_window_data.R
\name{make_time_window_data}
\alias{make_time_window_data}
\title{Make a dataset collapsing over a time-window}
\usage{
make_time_window_data(data, aois = NULL, predictor_columns = NULL,
  summarize_by = NULL)
}
\arguments{
\item{data}{The output of \code{make_eyetrackingr_data}}

\item{aois}{Which AOIs are of interest? Defaults to all in 'data_options'}

\item{predictor_columns}{Which columns indicate predictor vars, and therefore should be preserved in
grouping operations?}

\item{summarize_by}{Should the data be summarized along, e.g., participants, items, etc.? If so, give
  column names here. If left blank, will leave trials distinct. The former is needed for more traditional
  analyses (t.tests, ANOVAs), while the latter is preferable for mixed-effects models (lmer)}
}
\value{
Data with proportion-looking and transformations (logit, arc-sin, etc.)
}
\description{
Collapse time across our entire window and return a dataframe ready for analyses
}
\details{
Aside from proportion looking (\code{Prop}), this function returns several columns useful for subsequent
analysis:

\itemize{
 \item \code{LogitAdjusted} - The logit is defined as \code{log( Prop / (1 - Prop) )}. This
 transformation attempts to map bounded \code{0,1} data to the real number line. Unfortunately,
 for data that is exactly 0 or 1, this is undefined. One solution is add a very small value to
 any datapoints that equal 0, and subtract a small value to any datapoints that equal 1 (we use
 1/2 the smallest nonzero value for this adjustment).
 \item \code{Elog} - Another way of calculating a corrected logit transformation is to
add a small value \code{epsilon} to both the numerator and denominator of the logit equation (we
use 0.5).
 \item \code{Weights} - These attempt to further correct the Elog transformation, since the
 variance of the logit depends on the mean. They can be used in a mixed effects model by setting
 the \code{weights=Weights} in \code{lmer} (note that this is the reciprocal of the
weights calculated in \href{http://talklab.psy.gla.ac.uk/tvw/elogit-wt.html}{this empirical logit
walkthrough}, so you do *not* set \code{weights = 1/Weights} as done there.)
 \item \code{ArcSin} - The arcsine-root transformation of the raw proportions, defined as
\code{asin(sqrt(Prop))}
}
}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition,
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE
)

# generate a dataset summarizing an AOI (Animate) by ParticipantName
response_window_agg_by_sub <- make_time_window_data(data,
                                                    aois='Animate',
                                                    summarize_by = "ParticipantName"
)

# optionally included additional columns for use as predictors
# in later statistical models
response_window_agg_by_sub <- make_time_window_data(data,
                                                    aois='Animate',
                                                    predictor_columns=c('Age','MCDI_Total'),
                                                    summarize_by = "ParticipantName"
)

# plot the aggregated data for sanity check
plot(response_window_agg_by_sub, predictor_columns="Age", dv = "LogitAdjusted")
}

