% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_sequence_data.R
\name{plot.time_sequence_data}
\alias{plot.time_sequence_data}
\title{Plot time-sequence data}
\usage{
\method{plot}{time_sequence_data}(x, predictor_column = NULL, dv = "Prop",
  model = NULL, ...)
}
\arguments{
\item{x}{Your data from \code{make_time_sequence_data}. Will be collapsed by
subject for plotting (unless already collapsed by some other factor).}

\item{predictor_column}{Data can be grouped by a predictor column (median split is performed if
numeric)}

\item{dv}{What measure of gaze do you want to use? (\code{Prop}, \code{Elog}, or
\code{ArcSin})}

\item{model}{(Optional) A growth-curve mixed effects model (from \code{lmer}) that
was used on the \code{time_sequence_data}. If model is given, this function will overlay the
predictions of that model on the data}

\item{...}{Ignored}
}
\value{
A ggplot object
}
\description{
Plot the timecourse of looking. Each AOI will be plotted in a separate pane, and data can be 
split into groups by a predictor column. Data is collapsed by subject for plotting. Supports
overlaying the predictions of a growth-curve mixed effects model on the data
}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE
)
response_time <- make_time_sequence_data(data, time_bin_size = 250, 
                                         predictor_columns = c("MCDI_Total"),
                                         aois = "Animate", summarize_by = "ParticipantName")

# visualize time results
plot(response_time, predictor_column = "MCDI_Total") 


}

