% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick.R
\name{pick}
\alias{pick}
\title{Choosing any rectangular data file using interactive GUI dialog box.}
\usage{
pick(file = NULL, mode = NULL, ...)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data (either a single string or a raw vector). The default is NULL, which pops up an interactive GUI file choose dialogue box for users unless an explicit path/to/filename is given.
Each corresponding function depending upon a file extension will be automatically matched and applied once you pick up your file using either the GUI-file-chooser dialog box or explicit path/to/filename.}

\item{mode}{Character value for session locale and encoding; available values are: "ko1" for "CP949"; "ko2" for "UTF-8" while both change R locale into Korean (default is the current locale and encoding of your R session).}

\item{...}{Any additional arguments available for each file type and extension:
\link[vroom]{vroom} for 'CSV' (Comma-Separated Values); 'CSV2' (Semicolon-Separated Values); 
'TSV' (Tab-Separated Values); 'txt' (plain text) files; 
\link[readxl]{read_excel} for 'Excel' files; \link[haven]{read_spss} for 'SPSS' files; \link[haven]{read_stata} for 'Stata' files; 
\link[haven]{read_sas} for 'SAS' files; \link[textreadr]{read_document} for 'Microsoft Word', 'PDF', 'RTF', 'HTML', 'HTM', and 'PHP' files; 
\link[jsonlite]{fromJSON} for 'JSON' files; \link[mboxr]{read_mbox} for 'mbox' files; \link[rmarkdown]{render} for 'Rmd' files; \link[base]{source} for 'R' files; \link[base]{readRDS} for 'RDS' files; \link[base]{load} for 'RDA' and 'RDATA' files.}
}
\value{
tibble (table data.frame) object of the chosen rectangular data file will be returned.
}
\description{
You can alternatively use this function for choosing *.csv, *.csv2, *.tsv, *.txt, *.xls, *.xlsx, *.json, *.html, *.htm, *.php, *.pdf, *.doc, *.docx, *.rtf, *.RData, *.Rda, *.RDS, *.sav (SPSS), *.por, *.sas7bdat, *.sas7bcat, *.dta, *.xpt, *.mbox, and *.Rmd files in an interactive GUI mode A file choose dialog box will be prompted.
}
\details{
pick


See example below.
}
\examples{
# Choosing file and saving it into a variable
## Scenario 1: Picking up a file using interactive GUI dialog box:
if(interactive()) {
  library(ezpickr)
## Use either `pick(mode="ko1")` or `pick(mode="ko2")` for Korean R users.
  data <- pick() 
}

## Scenario 2: Picking up a file using an explicit file name ("test.sav" in the example below;
## however, you can feed other files through this function
## such as *.SAS, *.DTA, *.csv, *.csv2, *.tsv, *.xlsx, *.txt,
## *.html, webpage URL, *doc, *.docx, *.pdf, *.rtf, *.json, *.Rda, *.Rdata, and more):
library(ezpickr)
test <- system.file("extdata", "airquality.sav", package = "ezpickr")
## Use either `pick(test, mode="ko1")` or `pick(test, mode="ko2")` for Korean R users.
data <- pick(test)

# Now you can use the imported file as a tibble.
str(data)
}
\seealso{
\link[ezpickr]{picko} for Korean users.
}
\author{
JooYoung Seo, \email{jooyoung@psu.edu}

Soyoung Choi, \email{sxc940@psu.edu}
}
\keyword{pick}
