% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ezsummary_quantitative.r
\name{ezsummary_quantitative}
\alias{ezsummary_quantitative}
\title{Simple Summary for Quantitative/binary variables}
\usage{
ezsummary_quantitative(tbl, n = FALSE, mean = TRUE, sd = TRUE,
  sem = FALSE, median = FALSE, quantile = FALSE, round.N = 3,
  flavor = "long", unit_markup = NULL)
}
\arguments{
\item{tbl}{The input matrix of data you would like to analyze.}

\item{n}{n is a True/False switch that controls whether counts(N) should be included in
the output}

\item{mean}{a T/F switch to control whether mean should be calculated}

\item{sd}{a T/F switch to control whether standard deviation should be calculated}

\item{sem}{a T/F switch to control whether standard error of the mean should be calculated}

\item{median}{a T/F switch to control whether median should be calculated}

\item{quantile}{a T/F switch to control whether 0%, 25%, 50%, 75% and 100% quantile should
be calculated}

\item{round.N}{Rounding Number}

\item{flavor}{Flavor has two possible inputs: "long" and "wide". "Long" is the default
setting which will put grouping information on the left side of the table. It is more
machine readable and is good to be passed into the next analytical stage if needed.
"Wide" is more print ready (except for column names, which you can fix in the next step,
or fix in LaTex or packages like \code{htmlTable}). In the "wide" mode, the analyzed
variable will be the only "ID" variable and all the stats values will be presented ogranized
by the grouping variables (if any). If there is no grouping, the outputs of "wide" and
"long" will be the same.}

\item{unit_markup}{When unit_markup is not NULL, it will call the ezmarkup function and
perform column combination here. To make everyone's life easier, I'm using the term "unit"
here. Each unit mean each group of statistical summary results. If you want to
know mean and stand deviation, these two values are your units so you can put something
like "[. (.)]" there}
}
\value{
It will return in the same format as a summarise_each function does
}
\description{
Function ezsummary_quantitative provides simple summary (Mean and
standard deviation with/without N) for quantitative data while function ezsummary_binary
provides simple summary (freq and percentage with/without total counts) for binary data.
These two function are simply wrappers outside of a summarise_each function. If
we just want to know the most basic statistical summary, this function can save us some
typing time. It also provide the option to include number of subjects inside the analyses.
}
\examples{
library(dplyr)
mtcars \%>\% group_by(am) \%>\% select(mpg, wt, qsec) \%>\% ezsummary_quantitative()
}

