% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-utils.R
\name{parceval}
\alias{parceval}
\title{Shortcut to turn String character into R code}
\usage{
parceval(...)
}
\arguments{
\item{...}{String character to be parsed and evaluated}
}
\value{
Any output generated by the evaluation of the string character.
}
\description{
Shortcut to \code{\link[base:parse]{base::parse()}} and \code{\link[base:eval]{base::eval()}} evaluate R expression in a
character string, and turns it into actual R code. This function is targeted
for interaction with external files (where expression is stored in text
format) ; for tidy elements where code expression is generated using
\code{\link[dplyr:mutate]{dplyr::mutate()}}, combined with \code{\link[base:paste]{base::paste0()}} ; in for while, map, etc.
loops where character string expression can be indexed or iteratively
generated and evaluated ; objects to be created (using assign, <- or <<- obj)
where the name of the R object is stored in a string. Some issues may occur
when parceval is used in a different environment, such as in a function.
Prefer eval(parse(text = ...) instead.
}
\examples{
{

##### Example 1 -------------------------------------------------------------
# Simple assignation will assign 'b' in parceval environment (which is
# associated to a function and different from .GlobalEnv, by definition).
# Double assignation will put 'b' in .GlobalEnv.
# (similar to assign(x = "b",value = 1,envir = .GlobalEnv))

a <- 1
parceval("print(a)")
my_code <- paste0("a <- a + ",rep(1,3), "; message('value of a: ', a)")
parceval(my_code)

##### Example 2 -------------------------------------------------------------
# use rowwise to directly use parceval in a tibble, or use a for loop.
library(dplyr)
library(tidyr)

tibble(cars) \%>\%
  mutate(
    to_eval = paste0(speed,"/",dist)) \%>\%
  rowwise() \%>\%
  mutate(
    eval = parceval(to_eval))

##### Example 3 -------------------------------------------------------------
# parceval can be parcevaled itself!

code_R <-
  'as_tibble(cars) \%>\%
  mutate(
    to_eval = paste0(speed,"/",dist)) \%>\%
  rowwise() \%>\%
  mutate(
    eval = parceval(to_eval))'

cat(code_R)
parceval(code_R)

}

}
\seealso{
\code{\link[base:parse]{base::parse()}}, \code{\link[base:eval]{base::eval()}}
}
