% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-utils.R
\name{silently_run}
\alias{silently_run}
\title{Shortcut to silently run a code chunk avoiding error, messages and warnings}
\usage{
silently_run(...)
}
\arguments{
\item{...}{R code}
}
\value{
The output of the R code, unless the output is a message, a warning or an
error, nothing will be returned in that case.
}
\description{
Shortcut avoiding user to get messages, warnings and being stopped by an
error. The usage is very similar to \code{\link[base:warning]{base::suppressWarnings()}}. This function
is targeted for function creators where user experience enhancement is
sought.
}
\examples{
{

as.integer("text")
silently_run(as.integer("text"))

}

}
\seealso{
\code{\link[base:invisible]{base::invisible()}}, \code{\link[base:warning]{base::suppressWarnings()}}, \code{\link[base:message]{base::suppressMessages()}}
}
