% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ets.R
\name{fitted.ETS}
\alias{fitted.ETS}
\title{Extract fitted values from a fable model}
\usage{
\method{fitted}{ETS}(object, ...)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{...}{Additional arguments for forecast model methods.}
}
\value{
A vector of fitted values.
}
\description{
Extracts the fitted values.
}
\examples{
as_tsibble(USAccDeaths) \%>\%
  model(ets = ETS(log(value) ~ season("A"))) \%>\% 
  fitted()
  
}
