% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/croston.R
\name{residuals.croston}
\alias{residuals.croston}
\title{Extract residuals from a fable model}
\usage{
\method{residuals}{croston}(object, ...)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{...}{Additional arguments for forecast model methods.}
}
\value{
A vector of fitted residuals.
}
\description{
Extracts the residuals.
}
\examples{
library(tsibble)
sim_poisson <- tsibble(
  time = yearmonth("2012 Dec") + seq_len(24),
  count = rpois(24, lambda = 0.3),
  index = time
)

sim_poisson \%>\%
  model(CROSTON(count)) \%>\%
  residuals()
}
