% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{fitted.ARIMA}
\alias{fitted.ARIMA}
\title{Extract fitted values from a fable model}
\usage{
\method{fitted}{ARIMA}(object, ...)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{...}{Other arguments passed to methods}
}
\value{
A vector of fitted values.
}
\description{
Extracts the fitted values.
}
\examples{
USAccDeaths \%>\%
  as_tsibble() \%>\%
  model(arima = ARIMA(log(value) ~ pdq(0, 1, 1) + PDQ(0, 1, 1))) \%>\%
  fitted()
}
