% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dable.R
\name{dable}
\alias{dable}
\title{Create a dable object}
\usage{
dable(..., response, method = NULL, seasons = list(), aliases = list())
}
\arguments{
\item{...}{Arguments passed to \code{\link[tsibble:tsibble]{tsibble::tsibble()}}.}

\item{response}{The response variable(s). A single response can be specified
directly via \code{response = y}, multiple responses should be use \code{response = c(y, z)}.}

\item{method}{The name of the decomposition method.}

\item{seasons}{A named list describing the structure of seasonal components
(such as \code{period}, and \code{base}).}

\item{aliases}{A named list of calls describing common aliases computed from
components.}
}
\description{
A dable (decomposition table) data class (\code{dcmp_ts}) which is a tsibble-like
data structure for representing decompositions. This data class is useful for
representing decompositions, as its print method describes how its columns
can be combined to produce the original data, and has a more appropriate
\code{autoplot()} method for displaying decompositions. Beyond this, a dable
(\code{dcmp_ts}) behaves very similarly to a tsibble (\code{tbl_ts}).
}
