% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\docType{data}
\name{ME}
\alias{ME}
\alias{MSE}
\alias{RMSE}
\alias{MAE}
\alias{MPE}
\alias{MAPE}
\alias{MASE}
\alias{RMSSE}
\alias{ACF1}
\alias{point_accuracy_measures}
\title{Point estimate accuracy measures}
\format{
An object of class \code{list} of length 8.
}
\usage{
ME(.resid, na.rm = TRUE, ...)

MSE(.resid, na.rm = TRUE, ...)

RMSE(.resid, na.rm = TRUE, ...)

MAE(.resid, na.rm = TRUE, ...)

MPE(.resid, .actual, na.rm = TRUE, ...)

MAPE(.resid, .actual, na.rm = TRUE, ...)

MASE(
  .resid,
  .train,
  demean = FALSE,
  na.rm = TRUE,
  .period,
  d = .period == 1,
  D = .period > 1,
  ...
)

RMSSE(
  .resid,
  .train,
  demean = FALSE,
  na.rm = TRUE,
  .period,
  d = .period == 1,
  D = .period > 1,
  ...
)

ACF1(.resid, na.action = stats::na.pass, demean = TRUE, ...)

point_accuracy_measures
}
\arguments{
\item{.resid}{A vector of residuals from either the training (model accuracy)
or test (forecast accuracy) data.}

\item{na.rm}{Remove the missing values before calculating the accuracy measure}

\item{...}{Additional arguments for each measure.}

\item{.actual}{A vector of responses matching the fitted values
(for forecast accuracy, \code{new_data} must be provided).}

\item{.train}{A vector of responses used to train the model
(for forecast accuracy, the \code{orig_data} must be provided).}

\item{demean}{Should the response be demeaned (MASE)}

\item{.period}{The seasonal period of the data (defaulting to 'smallest' seasonal period).
from a model, or forecasted values from the forecast.}

\item{d}{Should the response model include a first difference?}

\item{D}{Should the response model include a seasonal difference?}

\item{na.action}{Function to handle missing values.}
}
\description{
Point estimate accuracy measures
}
\keyword{datasets}
