% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_cox.R
\name{box_cox}
\alias{box_cox}
\alias{inv_box_cox}
\title{Box Cox Transformation}
\usage{
box_cox(x, lambda)

inv_box_cox(x, lambda)
}
\arguments{
\item{x}{a numeric vector.}

\item{lambda}{a numeric value for the transformation parameter.}
}
\value{
a transformed numeric vector of the same length as x.
}
\description{
\code{box_cox()} returns a transformation of the input variable using a Box-Cox
transformation. \code{inv_box_cox()} reverses the transformation.
}
\details{
The Box-Cox transformation is given by \deqn{f_\lambda(x) =\frac{x^\lambda -
1}{\lambda}}{f(x;lambda)=(x^lambda - 1)/lambda} if \eqn{\lambda\ne0}{lambda
is not equal to 0}. For \eqn{\lambda=0}{lambda=0},
\deqn{f_0(x)=\log(x)}{f(x;0)=log(x)}.
}
\examples{
library(tsibble)
library(dplyr)
airmiles \%>\% 
  as_tsibble() \%>\% 
  mutate(box_cox = box_cox(value, lambda = 0.3))

}
\references{
Box, G. E. P. and Cox, D. R. (1964) An analysis of
transformations. \emph{JRSS B} \bold{26} 211--246.
}
\author{
Rob J Hyndman & Mitchell O'Hara-Wild
}
