% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_levels.R
\name{join}
\alias{join}
\title{Helper function handling specification of which variables to join a
cross-classified data on, and what kind of correlation structure needed.
Correlation structures can only be provided if the underlying call is
a `link_levels()` call.}
\usage{
join(..., rho = 0, sigma = NULL)
}
\arguments{
\item{...}{A series of two or more variable names, unquoted, to join on in
order to create cross-classified data.}

\item{rho}{A fixed (Spearman's rank) correlation coefficient between the
variables being joined on: note that if it is not possible to make a
correlation matrix from this coefficient (e.g. if you are joining on three
or more variables and rho is negative) then the \code{cross_levels()} call
will fail. Do not provide \code{rho} if making panel data.}

\item{sigma}{A matrix with dimensions equal to the number of variables you
are joining on, specifying the correlation for the resulting joined data.
Only one of rho and sigma should be provided. Do not provide \code{sigma} if
making panel data.}
}
\description{
Helper function handling specification of which variables to join a
cross-classified data on, and what kind of correlation structure needed.
Correlation structures can only be provided if the underlying call is
a `link_levels()` call.
}
