% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{community}
\alias{community}
\title{community}
\usage{
community(maxtime, numstages, parameters, init, interactionsD, interactionsG,
  interactionsR, height = 100, width = 100, boundary = c("reflexive",
  "absortive", "periodic"), dispKernel = c("exponential", "random"),
  starttime = 0, maxpop = 30000)
}
\arguments{
\item{maxtime}{How long the simulation must run}

\item{numstages}{Array of number of stages for each population}

\item{parameters}{Data.frame or matrix with one row for each stage. Columns:
D,G,R,dispersal distance,radius(optional),maxstressefect (optional)}

\item{init}{Either an array of initial numbers for each stage of each population, or a
data.frame with the history of a simulation}

\item{interactionsD}{Optional. A square matrix of effects of life stages over each other, where element
[i,j] is the effect of stage i over stage j. Positive values equal facilitation, negative
ones, competition. The interactions occur only if the affected individual is within the affecting
individual's radius, and are additive. Affects death rates (is subtracted from D).}

\item{interactionsG}{Same as above, but affecting growth rates (is added to G).}

\item{interactionsR}{Same as above, but affecting reproduction rates (is added to R) .}

\item{height}{Arena height}

\item{width}{Arena width}

\item{boundary}{Type of boundary condition. Options are "reflexive", "absortive" and
"periodic". Default is reflexive.}

\item{dispKernel}{Type of dispersion kernel. Options are "exponential" and "random", in which
seeds are dispersed randomly regardless of parent position (note: "random" option ignores
dispersal parameter)}

\item{starttime}{use for proceeding simulations. Time when simulation begins.}

\item{maxpop}{If the simulation reaches this many individuals total, it will stop. Default
is 30000.}
}
\description{
Runs a simulation with any number of structured populations, for a limited time.
}
\examples{
param <- data.frame(D=c(2,1,2,1),G=c(2,0,2,0),R=c(0,3,0,3),dispersal=c(0,2,0,20))
malth <- community(2,c(2,2),param,init=c(10,10,10,10))
ab <- abundance.matrix(malth)
stackplot(ab[,1:2]) # species 1
stackplot(ab[,3:4]) # species 2
}
