% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvdraws.R
\name{runningcovmat}
\alias{runningcovmat}
\title{Extract summary statistics for the posterior covariance matrix
which have been stored during sampling}
\usage{
runningcovmat(x, i, statistic = "mean", type = "cov")
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
of \code{\link{fsvsample}}.}

\item{i}{A single point in time.}

\item{statistic}{Indicates which statistic should be extracted. Defaults
to \code{'mean'}.}

\item{type}{Indicates whether covariance (\code{cov}) or correlation
(\code{cor}) should be extracted.}
}
\value{
Matrix containing the requested covariance matrix summary statistic.
}
\description{
\code{runningcovmat} extracts summary statistics from the model-implied
covariance matrix
from an \code{fsvdraws} object for one point in time.
}
\examples{
\dontrun{
set.seed(1)
sim <- fsvsim(n = 500, series = 3, factors = 1) # simulate 
res <- fsvsample(sim$y, factors = 1, runningstore = 6) # estimate

cov100mean <- runningcovmat(res, 100) # extract mean at t = 100
cov100sd <- runningcovmat(res, 100, statistic = "sd") # extract sd
lower <- cov100mean - 2*cov100sd
upper <- cov100mean + 2*cov100sd

true <- covmat(sim, 100) # true value

# Visualize mean +/- 2sd and data generating values
par(mfrow = c(3,3), mar = c(2, 2, 2, 2))
for (i in 1:3) {
 for (j in 1:3) {
  plot(cov100mean[i,j], ylim = range(lower, upper), pch = 3,
  main = paste(i, j, sep = ' vs. '), xlab = '', ylab = '')
  lines(c(1,1), c(lower[i,j], upper[i,j]))
  points(true[i,j,1], col = 3, cex = 2)
 }
}
}

}
\seealso{
Other extractors: \code{\link{covmat.fsvdraws}},
  \code{\link{runningcormat}}
}

