# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Components operations
#' @description factset.analyticsapi.engines.Components
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ GetPAComponentById } \emph{ Get PA component by id }
#' This endpoint returns the default settings of a PA component.
#'
#' \itemize{
#' \item \emph{ @param } id character
#' \item \emph{ @returnType } \link{PAComponent} \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns the default settings of a PA component.
#'
#' \item return type : PAComponent 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid PA component id.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | Component not found.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' \strong{ GetPAComponents } \emph{ Get PA components }
#' This endpoint returns the list of PA components in a given PA document.
#'
#' \itemize{
#' \item \emph{ @param } document character
#' \item \emph{ @returnType } named list( \link{ComponentSummary} ) \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns a list of PA components.
#'
#' \item return type : map(ComponentSummary) 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid query parameter provided or Invalid PA document name.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | Document not found.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' \strong{ GetSPARComponents } \emph{ Get SPAR components }
#' This endpoint returns the list of SPAR components in a given SPAR document.
#'
#' \itemize{
#' \item \emph{ @param } document character
#' \item \emph{ @returnType } named list( \link{ComponentSummary} ) \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns a list of SPAR components.
#'
#' \item return type : map(ComponentSummary) 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid query parameter provided or Invalid SPAR document name.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | SPAR Document not found.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' \strong{ GetVaultComponentById } \emph{ Get Vault component by id }
#' This endpoint returns the default settings of a Vault component.
#'
#' \itemize{
#' \item \emph{ @param } id character
#' \item \emph{ @returnType } \link{VaultComponent} \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns the default settings of a Vault component.
#'
#' \item return type : VaultComponent 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid Vault component id.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | Vault Component not found.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' \strong{ GetVaultComponents } \emph{ Get Vault components }
#' This endpoint returns the list of Vault components in a given Vault document.
#'
#' \itemize{
#' \item \emph{ @param } document character
#' \item \emph{ @returnType } named list( \link{ComponentSummary} ) \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns a list of Vault components.
#'
#' \item return type : map(ComponentSummary) 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid query parameter provided or invalid Vault document name.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | Vault Document not found.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \dontrun{
#' ####################  GetPAComponentById  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.id <- 'id_example' # character | Unique identifier for a PA component
#'
#' #Get PA component by id
#' api.instance <- ComponentsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetPAComponentById(var.id),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' ####################  GetPAComponents  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.document <- 'document_example' # character | Document Name
#'
#' #Get PA components
#' api.instance <- ComponentsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetPAComponents(var.document),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' ####################  GetSPARComponents  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.document <- 'document_example' # character | Document Name
#'
#' #Get SPAR components
#' api.instance <- ComponentsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetSPARComponents(var.document),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' ####################  GetVaultComponentById  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.id <- 'id_example' # character | Unique identifier for a vault component
#'
#' #Get Vault component by id
#' api.instance <- ComponentsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetVaultComponentById(var.id),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' ####################  GetVaultComponents  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.document <- 'document_example' # character | Document Name
#'
#' #Get Vault components
#' api.instance <- ComponentsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetVaultComponents(var.document),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom caTools base64encode
#' @importFrom rlang abort
#' @export
ComponentsApi <- R6::R6Class(
  'ComponentsApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    GetPAComponentById = function(id, ...){
      apiResponse <- self$GetPAComponentByIdWithHttpInfo(id, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetPAComponentByIdWithHttpInfo = function(id, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`id`)) {
        rlang::abort(message = "Missing required parameter `id`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `id`."))
      }

      urlPath <- "/analytics/lookups/v2/engines/pa/components/{id}"
      if (!missing(`id`)) {
        urlPath <- gsub(paste0("\\{", "id", "\\}"), URLencode(as.character(`id`), reserved = TRUE), urlPath)
      }

      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "PAComponent", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    },
    GetPAComponents = function(document, ...){
      apiResponse <- self$GetPAComponentsWithHttpInfo(document, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetPAComponentsWithHttpInfo = function(document, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`document`)) {
        rlang::abort(message = "Missing required parameter `document`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `document`."))
      }

      queryParams['document'] <- document

      urlPath <- "/analytics/lookups/v2/engines/pa/components"
      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "map(ComponentSummary)", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    },
    GetSPARComponents = function(document, ...){
      apiResponse <- self$GetSPARComponentsWithHttpInfo(document, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetSPARComponentsWithHttpInfo = function(document, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`document`)) {
        rlang::abort(message = "Missing required parameter `document`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `document`."))
      }

      queryParams['document'] <- document

      urlPath <- "/analytics/lookups/v2/engines/spar/components"
      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "map(ComponentSummary)", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    },
    GetVaultComponentById = function(id, ...){
      apiResponse <- self$GetVaultComponentByIdWithHttpInfo(id, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetVaultComponentByIdWithHttpInfo = function(id, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`id`)) {
        rlang::abort(message = "Missing required parameter `id`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `id`."))
      }

      urlPath <- "/analytics/lookups/v2/engines/vault/components/{id}"
      if (!missing(`id`)) {
        urlPath <- gsub(paste0("\\{", "id", "\\}"), URLencode(as.character(`id`), reserved = TRUE), urlPath)
      }

      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "VaultComponent", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    },
    GetVaultComponents = function(document, ...){
      apiResponse <- self$GetVaultComponentsWithHttpInfo(document, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetVaultComponentsWithHttpInfo = function(document, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`document`)) {
        rlang::abort(message = "Missing required parameter `document`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `document`."))
      }

      queryParams['document'] <- document

      urlPath <- "/analytics/lookups/v2/engines/vault/components"
      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "map(ComponentSummary)", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    }
  )
)
