% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_scores.R
\name{metric_scores}
\alias{metric_scores}
\title{Metric scores}
\usage{
metric_scores(x, fairness_metrics = unique_metrics())
}
\arguments{
\item{x}{object of class \code{fairness_object}}

\item{fairness_metrics}{character, vector with fairness metric names}
}
\value{
\code{metric_scores} object.
It is a list containing:
\itemize{
\item{metric_scores_data}{ - \code{data.frame} with information about score in particular subgroup, metric, and model}
\item{privileged}{ - name of privileged subgroup}
}
}
\description{
Creates \code{metric_scores} object to facilitate visualization. Check how the metric scores differ among models, what is this score, and how it changes
for example after applying bias mitigation technique. The vertical black lines
denote the scores for privileged subgroup. It is best to use only few metrics (using \code{fairness_metrics} parameter)
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

ms <- metric_scores(fobject, fairness_metrics = c("TPR","STP","ACC"))
plot(ms)

}
