% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fairness_pca.R
\name{plot.fairness_pca}
\alias{plot.fairness_pca}
\title{Plot fairness PCA}
\usage{
\method{plot}{fairness_pca}(x, scale = 0.5, ...)
}
\arguments{
\item{x}{\code{fairness_pca} object}

\item{scale}{scaling loadings plot, from 0 to 1}

\item{...}{other plot parameters}
}
\value{
\code{ggplot2} object
}
\description{
Plot pca calculated on fairness_object metrics. Similar models and metrics should be close to each other. Plot doesn't work on multiple \code{fairness_pca} objects.
Unlike in other plots here other \code{fairness_pca} objects cannot be added.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200,
                           num.threads = 1)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

 # same explainers with different cutoffs for female
fobject <- fairness_check(explainer_lm, explainer_rf, fobject,
                          protected = german$Sex,
                          privileged = "male",
                          cutoff = list( female = 0.4),
                          label = c("lm_2", "rf_2"))

fpca <- fairness_pca(fobject)

plot(fpca)

}
