% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal_odds.R
\name{equal_odds}
\alias{equal_odds}
\title{Equalized Odds}
\usage{
equal_odds(data, outcome, group, probs = NULL, preds = NULL,
  outcome_levels = NULL, cutoff = 0.5, base = NULL)
}
\arguments{
\item{data}{The dataframe that contains the necessary columns.}

\item{outcome}{The column name of the actual outcomes.}

\item{group}{Sensitive group to examine.}

\item{probs}{The column name or vector of the predicted probabilities (numeric between 0 - 1). If not defined, argument preds needs to be defined.}

\item{preds}{The column name or vector of the predicted outcome (categorical outcome). If not defined, argument probs needs to be defined.}

\item{outcome_levels}{The desired levels of the predicted outcome (categorical outcome). If not defined, all unique values of outcome are used.}

\item{cutoff}{Cutoff to generate predicted outcomes from predicted probabilities. Default set to 0.5.}

\item{base}{Base level for sensitive group comparison}
}
\value{
\item{Metric}{Raw sensitivities for all groups and metrics standardized for the base group (equalized odds parity metric). Lower values compared to the reference group mean lower sensitivities in the selected subgroups}
\item{Metric_plot}{Bar plot of Equalized Odds metric}
\item{Probability_plot}{Density plot of predicted probabilities per subgroup. Only plotted if probabilities are defined}
}
\description{
This function computes the Equalized Odds metric
}
\details{
This function computes the Equalized Odds metric (also known as Equal Opportunity, Positive Rate Parity or Separation). Equalized Odds are calculated
by the division of true positives with all positives (irrespective of predicted values). This metrics equals to
what is traditionally known as sensitivity. In the returned
named vector, the reference group will be assigned 1, while all other groups will be assigned values
according to whether their sensitivities are lower or higher compared to the reference group. Lower
sensitivities will be reflected in numbers lower than 1 in the returned named vector, thus numbers
lower than 1 mean WORSE prediction for the subgroup.
}
\examples{
data(compas)
equal_odds(data = compas, outcome = 'Two_yr_Recidivism', group = 'ethnicity',
probs = 'probability', preds = NULL, outcome_levels = c('no', 'yes'),
cutoff = 0.4, base = 'Caucasian')
equal_odds(data = compas, outcome = 'Two_yr_Recidivism', group = 'ethnicity',
probs = NULL, preds = 'predicted', outcome_levels = c('no', 'yes'),
cutoff = 0.5, base = 'Hispanic')

}
