% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{Concordance}
\alias{Concordance}
\title{Concordance statistic}
\usage{
Concordance(observed, predicted)
}
\arguments{
\item{observed}{vector of binary outcomes.}

\item{predicted}{vector of predicted probabilities.}
}
\value{
The concordance statistic.
}
\description{
Computes the concordance statistic given observed binary outcomes and
predicted probabilities of event. In logistic regression, the concordance
statistic is equal to the area under the Receiver Operating Characteristic
(ROC) curve and estimates the probability that an individual who experienced
the event (\eqn{Y_i=1}) had a higher probability of event than an individual
who did not experience the event (\eqn{Y_i=0}).
}
\examples{

# Data simulation
set.seed(1)
proba <- runif(n = 200)
ydata <- rbinom(n = length(proba), size = 1, prob = proba)

# Observed concordance in simulated data
Concordance(observed = ydata, predicted = proba)

}
\seealso{
Other goodness of fit functions: 
\code{\link{ROC}()}
}
\concept{goodness of fit functions}
