% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{MinWithinProba}
\alias{MinWithinProba}
\title{Within-group probabilities for communities}
\usage{
MinWithinProba(pk, nu_between = 0, nu_mat = NULL)
}
\arguments{
\item{pk}{vector of the number of variables per group in the simulated
dataset. The number of nodes in the simulated graph is \code{sum(pk)}. With
multiple groups, the simulated (partial) correlation matrix has a block
structure, where blocks arise from the integration of the \code{length(pk)}
groups. This argument is only used if \code{theta} is not provided.}

\item{nu_between}{probability of having an edge between two nodes belonging
to different groups, as defined in \code{pk}. By default, the same density
is used for within and between blocks (\code{nu_within}=\code{nu_between}).
Only used if \code{length(pk)>1}. Only used if \code{nu_mat} is not
provided.}

\item{nu_mat}{matrix of probabilities of having an edge between nodes
belonging to a given pair of node groups defined in \code{pk}. Only
off-diagonal entries are used.}
}
\value{
A vector of within-group probabilities.
}
\description{
Computes the smallest within-group probabilities that can be used to simulate
a graph where communities can be expected for given probabilities of
between-group probabilities and group sizes.
}
\details{
The vector of within-group probabilities is the smallest one that
  can be used to generate an expected total within degree \eqn{D^w_k}
  strictly higher than the expected total between degree \eqn{D^b_k} for all
  communities \eqn{k} (see \code{\link{ExpectedCommunities}}). Namely, using
  the suggested within-group probabilities would give expected \eqn{D^w_k =
  D^b_k + 1}.
}
\examples{
# Simulation parameters
pk <- rep(20, 4)
nu_between <- 0.1

# Estimating smallest nu_within
nu_within <- MinWithinProba(pk = pk, nu_between = nu_between)

# Expected metrics
ExpectedCommunities(
  pk = pk,
  nu_within = max(nu_within),
  nu_between = nu_between
)

}
\seealso{
\code{\link{ExpectedCommunities}}, \code{\link{SimulateAdjacency}},
  \code{\link{SimulateGraphical}}
}
