% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{ExpectedConcordance}
\alias{ExpectedConcordance}
\title{Expected concordance statistic}
\usage{
ExpectedConcordance(probabilities)
}
\arguments{
\item{probabilities}{vector of probabilities of event.}
}
\value{
The expected concordance statistic.
}
\description{
Computes the expected concordance statistic given true probabilities of
event. In logistic regression, the concordance statistic is equal to the area
under the Receiver Operating Characteristic (ROC) curve and estimates the
probability that an individual who experienced the event (\eqn{Y_i=1}) had a
higher probability of event than an individual who did not experience the
event (\eqn{Y_i=0}).
}
\examples{

# Simulation of probabilities
set.seed(1)
proba <- runif(n = 1000)

# Expected concordance
ExpectedConcordance(proba)

# Simulation of binary outcome
ydata <- rbinom(n = length(proba), size = 1, prob = proba)

# Observed concordance in simulated data
Concordance(observed = ydata, predicted = proba)

}
\seealso{
\code{\link{Concordance}}
}
