% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarS4Classes.R
\docType{class}
\name{outcomeInfo-class}
\alias{outcomeInfo-class}
\title{Outcome information object.}
\description{
An outcome information object stores data concerning an outcome. This is used
to prospectively check data.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the outcome, inherited from the original column name by
default.}

\item{\code{outcome_type}}{Type of outcome.}

\item{\code{outcome_column}}{Name of the outcome column in data.}

\item{\code{levels}}{Specifies class levels of categorical outcomes.}

\item{\code{ordered}}{Specifies whether categorical outcomes are ordered.}

\item{\code{reference}}{Class level used as reference.}

\item{\code{time}}{Maximum time, as set by the `time_max` configuration parameter.}

\item{\code{censored}}{Censoring indicators for survival outcomes.}

\item{\code{event}}{Event indicators for survival outcomes.}

\item{\code{competing_risk}}{Indicators for competing risks in survival outcomes.}

\item{\code{distribution}}{Five-number summary (numeric outcomes), class frequency
(categorical outcomes), or survival distributions.}

\item{\code{data_id}}{Internal identifier for the dataset used to derive the outcome
information.}

\item{\code{run_id}}{Internal identifier for the specific subset of the dataset used
to derive the outcome information.}

\item{\code{transformation_parameters}}{Parameters used for transforming a numeric
outcomes. Currently unused.}

\item{\code{normalisation_parameters}}{Parameters used for normalising numeric
outcomes. Currently unused.}
}}

