% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParseSettings.R
\name{.parse_feature_selection_settings}
\alias{.parse_feature_selection_settings}
\title{Internal function for parsing settings related to feature selection}
\usage{
.parse_feature_selection_settings(
  config = NULL,
  data,
  parallel,
  outcome_type,
  fs_method = waiver(),
  fs_method_parameter = waiver(),
  vimp_aggregation_method = waiver(),
  vimp_aggregation_rank_threshold = waiver(),
  parallel_feature_selection = waiver(),
  ...
)
}
\arguments{
\item{config}{A list of settings, e.g. from an xml file.}

\item{data}{Data set as loaded using the \code{.load_data} function.}

\item{parallel}{Logical value that whether familiar uses parallelisation. If
\code{FALSE} it will override \code{parallel_feature_selection}.}

\item{outcome_type}{Type of outcome found in the data set.}

\item{fs_method}{(\strong{required}) Feature selection method to be used for
determining variable importance. \code{familiar} implements various feature
selection methods. Please refer to the vignette on feature selection
methods for more details.

More than one feature selection method can be chosen. The experiment will
then repeated for each feature selection method.

Feature selection methods determines the ranking of features. Actual
selection of features is done by optimising the signature size model
hyperparameter during the hyperparameter optimisation step.}

\item{fs_method_parameter}{(\emph{optional}) List of lists containing parameters
for feature selection methods. Each sublist should have the name of the
feature selection method it corresponds to.

Most feature selection methods do not have parameters that can be set.
Please refer to the vignette on feature selection methods for more details.
Note that if the feature selection method is based on a learner (e.g. lasso
regression), hyperparameter optimisation may be performed prior to
assessing variable importance.}

\item{vimp_aggregation_method}{(\emph{optional}) The method used to aggregate
variable importances over different data subsets, e.g. bootstraps. The
following methods can be selected:
\itemize{
\item \code{none}: Don't aggregate ranks, but rather aggregate the variable
importance scores themselves.
\item \code{mean}: Use the mean rank of a feature over the subsets to
determine the aggregated feature rank.
\item \code{median}: Use the median rank of a feature over the subsets to determine
the aggregated feature rank.
\item \code{best}: Use the best rank the feature obtained in any subset to determine
the aggregated feature rank.
\item \code{worst}: Use the worst rank the feature obtained in any subset to
determine the aggregated feature rank.
\item \code{stability}: Use the frequency of the feature being in the subset of
highly ranked features as measure for the aggregated feature rank
(Meinshausen and Buehlmann, 2010).
\item \code{exponential}: Use a rank-weighted frequence of occurrence in the subset
of highly ranked features as measure for the aggregated feature rank (Haury
et al., 2011).
\item \code{borda} (default): Use the borda count as measure for the aggregated
feature rank (Wald et al., 2012).
\item \code{enhanced_borda}: Use an occurrence frequency-weighted borda count as
measure for the aggregated feature rank (Wald et al., 2012).
\item \code{truncated_borda}: Use borda count computed only on features within the
subset of highly ranked features.
\item \code{enhanced_truncated_borda}: Apply both the enhanced borda method and the
truncated borda method and use the resulting borda count as the aggregated
feature rank.
}

The \emph{feature selection methods} vignette provides additional information.}

\item{vimp_aggregation_rank_threshold}{(\emph{optional}) The threshold used to
define the subset of highly important features. If not set, this threshold
is determined by maximising the variance in the occurrence value over all
features over the subset size.

This parameter is only relevant for \code{stability}, \code{exponential},
\code{enhanced_borda}, \code{truncated_borda} and \code{enhanced_truncated_borda} methods.}

\item{parallel_feature_selection}{(\emph{optional}) Enable parallel processing for
the feature selection workflow. Defaults to \code{TRUE}. When set to \code{FALSE},
this will disable the use of parallel processing while performing feature
selection, regardless of the settings of the \code{parallel} parameter.
\code{parallel_feature_selection} is ignored if \code{parallel=FALSE}.}

\item{...}{Unused arguments.}
}
\value{
List of parameters related to feature selection.
}
\description{
Internal function for parsing settings related to feature selection
}
\references{
\enumerate{
\item Wald, R., Khoshgoftaar, T. M., Dittman, D., Awada, W. &
Napolitano, A. An extensive comparison of feature ranking aggregation
techniques in bioinformatics. in 2012 IEEE 13th International Conference on
Information Reuse Integration (IRI) 377–384 (2012).
\item Meinshausen, N. & Buehlmann, P. Stability selection. J. R. Stat. Soc.
Series B Stat. Methodol. 72, 417–473 (2010).
\item Haury, A.-C., Gestraud, P. & Vert, J.-P. The influence of feature
selection methods on accuracy, stability and interpretability of molecular
signatures. PLoS One 6, e28210 (2011).
}
}
\keyword{internal}
