/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.Crop;
import jfm.model.CropYear;
import jfm.model.CroppingComponent;
import jfm.model.Farm;
import jfm.model.Location;
import jfm.model.Operation;
import jfm.model.Types;
import jfm.model.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeTimeComponent
extends ModelComponent {
    private ArrayList<Double> preferenceWeights = new ArrayList();
    private Map<Integer, MatrixVariable> freeTimeByPeriod = new HashMap<Integer, MatrixVariable>();

    public FreeTimeComponent() {
        super(ModelComponent.MCType.FREETIME);
        this.requireObjective(Types.ObjectiveType.FREETIME);
        this.addConstraintBuilder(new FreeTimeVResourcesConstraint());
        this.addConstraintBuilder(new FreeTimeMaxConstraint());
    }

    @Override
    public FreeTimeComponent copy() {
        return new FreeTimeComponent();
    }

    @Override
    public void setFormulaVariables() {
    }

    public Map<Integer, Double> getSolvedFreeTime() {
        HashMap<Integer, Double> ft = new HashMap<Integer, Double>();
        for (Integer p : this.freeTimeByPeriod.keySet()) {
            ft.put(p, this.freeTimeByPeriod.get(p).solution());
        }
        return ft;
    }

    @Override
    protected void initializeStructure() {
        int p;
        this.freeTimeByPeriod.clear();
        Farm parent = this.getParent();
        if (this.preferenceWeights.size() == 0) {
            for (p = 0; p < parent.numPeriods; ++p) {
                this.preferenceWeights.add(1.0);
            }
        }
        if (this.preferenceWeights.size() != parent.numPeriods) {
            throw new Error("preference weights on free time do not match the number of periods ");
        }
        for (p = 0; p < parent.numPeriods; ++p) {
            MatrixVariable newVariable = new MatrixVariable(this.preferenceWeights.get(p), 0.0, 0.0, LPX.LPX_LO, LPX.LPX_CV, this.matrix.numCols(), Types.ObjectiveType.FREETIME);
            newVariable.setTag("ft_" + p);
            this.matrix.addVariable(newVariable);
            this.freeTimeByPeriod.put(p, newVariable);
        }
    }

    @Override
    protected String name() {
        return "Free Time";
    }

    @Override
    protected void updateStructure() {
    }

    public final class FreeTimeVResourcesConstraint
    extends ConstraintBuilder {
        public FreeTimeVResourcesConstraint() {
            super(ConstraintBuilder.CBType.FREETIMEVRESOURCES, ModelComponent.MCType.FREETIME);
        }

        protected void build() {
            Farm parent = FreeTimeComponent.this.getParent();
            CroppingComponent cropping = parent.cropping;
            Location location = parent.location();
            int numPeriods = parent.numPeriods;
            int row = FreeTimeComponent.this.matrix.numRows();
            HashMap<Types.WorkerSubType, Worker> wmap = parent.workers.getWorkers(Types.WorkerType.LABOUR);
            if (!wmap.containsKey((Object)Types.WorkerSubType.FARMER)) {
                throw new Error("Can't add constraint to free time objective because no Farmer WorkerSubType defined ");
            }
            Worker fmrp = wmap.get((Object)Types.WorkerSubType.FARMER);
            HashMap<Integer, MatrixRow> rowlist = new HashMap<Integer, MatrixRow>();
            MatrixRow rp = null;
            for (int p = 0; p < numPeriods * Farm.maxYears; ++p) {
                int periodicp = Farm.wrapPeriod(p, numPeriods);
                if (!rowlist.containsKey(periodicp)) {
                    rp = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, "FreeTime", "Freetime_in_" + p);
                    FreeTimeComponent.this.matrix.addRow(rp);
                    rowlist.put(periodicp, rp);
                    ++row;
                }
                rp = (MatrixRow)rowlist.get(periodicp);
                rp.addElement(new MatrixElement(((MatrixVariable)FreeTimeComponent.this.freeTimeByPeriod.get(periodicp)).column(), -1.0));
                double avail = location.availableFreeTimeHours(periodicp);
                rp.addElement(new MatrixElement(fmrp.getDependentColumn(0), avail));
                for (Worker otherlab : wmap.values()) {
                    if (otherlab.subType == Types.WorkerSubType.FARMER) continue;
                    rp.addElement(new MatrixElement(otherlab.getDependentColumn(0), location.availableHours(periodicp)));
                }
                for (CropYear cropyr : cropping.cropYears()) {
                    Crop.CropCopy cp = cropping.getCrop(cropyr.base).getCopy(cropyr.copyYear);
                    List<Operation> cpOps = cp.operations();
                    int numops = cpOps.size();
                    for (int o = 0; o < numops; ++o) {
                        Operation op = cpOps.get(o);
                        if (!op.unfoldedAllowedSet().contains(p) || !op.requiresWorker(Types.WorkerType.LABOUR)) continue;
                        double required = op.workrate(location) * (double)op.numRequiredForWorkerType(Types.WorkerType.LABOUR).intValue();
                        rp.addElement(new MatrixElement(op.getDependentColumn(p), -required));
                    }
                }
            }
        }
    }

    public final class FreeTimeMaxConstraint
    extends ConstraintBuilder {
        public FreeTimeMaxConstraint() {
            super(ConstraintBuilder.CBType.FREETIMEMAX, ModelComponent.MCType.FREETIME);
        }

        protected void build() {
            Farm parent = FreeTimeComponent.this.getParent();
            Location loc = parent.location();
            int numPeriods = parent.numPeriods;
            int row = FreeTimeComponent.this.matrix.numRows();
            HashMap<Types.WorkerSubType, Worker> wmap = parent.workers.getWorkers(Types.WorkerType.LABOUR);
            if (!wmap.containsKey((Object)Types.WorkerSubType.FARMER)) {
                throw new Error("Can't add constraint to free time objective because no Farmer WorkerSubType defined ");
            }
            Worker fmrp = wmap.get((Object)Types.WorkerSubType.FARMER);
            for (int p = 0; p < numPeriods; ++p) {
                MatrixRow rp = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, "FreeTime", "Freetime_in_p_" + p);
                FreeTimeComponent.this.matrix.addRow(rp);
                ++row;
                rp.addElement(new MatrixElement(((MatrixVariable)FreeTimeComponent.this.freeTimeByPeriod.get(p)).column(), -1.0));
                double avail = loc.availableFreeTimeHours(p);
                rp.addElement(new MatrixElement(fmrp.getDependentColumn(0), avail));
            }
        }
    }
}

