/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import jfm.model.Types;
import jfm.xml.JFMObjectParser;
import jfm.xml.ObjectParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

public class TextParser
extends JFMObjectParser {
    private int length = -1;
    public Types.TextDataType dataType = null;
    public Types.OperationType opType = null;
    public Types.WorkerType wkType = null;

    public TextParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("length", JFMObjectParser.optionalAttribute);
        this.registerAttribute("data", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("wktype", JFMObjectParser.optionalAttribute);
        this.registerAttribute("optype", JFMObjectParser.optionalAttribute);
    }

    public void initializeObject() throws XMLObjectException, XMLSyntaxException {
        try {
            if (this.textContent == null) {
                throw new XMLSyntaxException("CSV elements must contain text");
            }
            if (this.attributeHasValue("length")) {
                this.length = Integer.parseInt(this.getNamedAttribute("length"));
            }
            if (this.length > -1 & this.textContent.split(",").length != this.length) {
                throw new XMLSyntaxException(this.printNameAndAttributes() + " specifies " + this.length + " entries but " + this.textContent.split(",").length + " supplied at " + this.parent.printNameAndAttributes());
            }
            this.obj = this.textContent;
            if (!this.attributeHasValue("data")) {
                throw new XMLSyntaxException("data is a mandatory attribute for csv fields");
            }
            this.dataType = Types.xmlToTextDataType(this.getNamedAttribute("data"));
            if (this.attributeHasValue("optype")) {
                this.opType = Types.xmlToOperationType(this.getNamedAttribute("optype"));
            }
            if (this.attributeHasValue("wktype")) {
                this.wkType = Types.xmlToWorkerType(this.getNamedAttribute("wktype"));
            }
        }
        catch (NumberFormatException ex) {
            throw new XMLSyntaxException("Bad number format for attribute");
        }
        catch (XMLSyntaxException tex) {
            tex.printStackTrace();
            throw new XMLSyntaxException(tex.getMessage());
        }
    }

    public String name() {
        if (this.dataType != null) {
            return this.dataType.xmlname;
        }
        return "textparser";
    }

    public String[] getCSV() {
        String objalias = (String)this.obj;
        return objalias.split(",");
    }

    public String parsesNode() {
        return "csv";
    }

    public String toString() {
        return "CSVParser";
    }

    protected boolean isPrimitive() {
        return true;
    }
}

