% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emlinkMARmov.R
\name{emlinkMARmov}
\alias{emlinkMARmov}
\title{emlinkMARmov}
\usage{
emlinkMARmov(patterns, nobs.a, nobs.b, p.m, iter.max,
tol, p.gamma.k.m, p.gamma.k.u, prior.lambda, w.lambda,
prior.pi, w.pi, address.field, gender.field, varnames)
}
\arguments{
\item{patterns}{table that holds the counts for each unique agreement
pattern. This object is produced by the function: tableCounts.}

\item{nobs.a}{Number of observations in dataset A}

\item{nobs.b}{Number of observations in dataset B}

\item{p.m}{probability of finding a match. Default is 0.1}

\item{iter.max}{Max number of iterations. Default is 5000}

\item{tol}{Convergence tolerance. Default is 1e-05}

\item{p.gamma.k.m}{probability that conditional of being in the matched set we observed a specific agreement value for field k.}

\item{p.gamma.k.u}{probability that conditional of being in the non-matched set we observed a specific agreement value for field k.}

\item{prior.lambda}{The prior probability of finding a match, derived from auxiliary data.}

\item{w.lambda}{How much weight to give the prior on lambda versus the data. Must range between 0 (no weight on prior) and 1 (weight fully on prior)}

\item{prior.pi}{The prior probability of the address field not matching, conditional on being in the matched set. To be used when the
share of movers in the population is known with some certainty.}

\item{w.pi}{How much weight to give the prior on pi versus the data. Must range between 0 (no weight on prior) and 1 (weight fully on prior)}

\item{address.field}{Boolean indicators for whether a given field is an address field. Default is NULL (FALSE for all fields).
Address fields should be set to TRUE while non-address fields are set to FALSE if provided.}

\item{gender.field}{Boolean indicators for whether a given field is for gender. If so, exact match is conducted on gender.
Default is NULL (FALSE for all fields). The one gender field should be set to TRUE while all other fields are set to FALSE if provided.}

\item{varnames}{The vector of variable names used for matching. Automatically provided if using \code{fastLink()} wrapper. Used for
clean visualization of EM results in summary functions.}
}
\value{
\code{emlinkMARmov} returns a list with the following components:
\item{zeta.j}{The posterior match probabilities for each unique pattern.}
\item{p.m}{The posterior probability of a pair matching.}
\item{p.u}{The posterior probability of a pair not matching.}
\item{p.gamma.k.m}{The posterior of the matching probability for a specific matching field.}
\item{p.gamma.k.u}{The posterior of the non-matching probability for a specific matching field.}
\item{p.gamma.j.m}{The posterior probability that a pair is in the matched set given a particular agreement pattern.}
\item{p.gamma.j.u}{The posterior probability that a pair is in the unmatched set given a particular agreement pattern.}
\item{patterns.w}{Counts of the agreement patterns observed, along with the Felligi-Sunter Weights.}
\item{iter.converge}{The number of iterations it took the EM algorithm to converge.}
\item{nobs.a}{The number of observations in dataset A.}
\item{nobs.b}{The number of observations in dataset B.}
}
\description{
Expectation-Maximization algorithm for Record Linkage under the
Missing at Random (MAR) assumption.
}
\examples{
\dontrun{
## Calculate gammas
g1 <- gammaCKpar(dfA$firstname, dfB$firstname)
g2 <- gammaCKpar(dfA$middlename, dfB$middlename)
g3 <- gammaCKpar(dfA$lastname, dfB$lastname)
g4 <- gammaKpar(dfA$birthyear, dfB$birthyear)

## Run tableCounts
tc <- tableCounts(list(g1, g2, g3, g4), nobs.a = nrow(dfA), nobs.b = nrow(dfB))

## Run EM
em <- emlinkMARmov(tc, nobs.a = nrow(dfA), nobs.b = nrow(dfB))
}

}
\author{
Ted Enamorado <ted.enamorado@gmail.com> and Kosuke Imai
}

