% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockData.R
\name{stringSubset}
\alias{stringSubset}
\title{stringSubset}
\usage{
stringSubset(vecA, vecB, similarity.threshold, stringdist.method,
jw.weight, n.cores)
}
\arguments{
\item{vecA}{A character or factor vector from dataset A}

\item{vecB}{A character or factor vector from dataset B}

\item{similarity.threshold}{Lower bound on string-distance measure for being considered a possible match.
If an observation has no possible matches above this threshold, it is discarded from the match. Default is 0.8.}

\item{stringdist.method}{The method to use for calculating string-distance similarity. Possible values are
'jaro' (Jaro Distance), 'jw' (Jaro-Winkler), and 'lv' (Levenshtein). Default is 'jw'.}

\item{jw.weight}{Parameter that describes the importance of the first characters of a string (only needed if stringdist.method = "jw"). Default is .10.}

\item{n.cores}{Number of cores to parallelize over. Default is NULL.}
}
\value{
A list of length two, where the both entries are a vector of indices to be included in the match from dataset A (entry 1) and dataset B (entry 2).
}
\description{
Removes as candidate matches any observations with no close matches on
string-distance measures.
}
\examples{
\dontrun{
subset_out <- stringSubset(dfA$firstname, dfB$lastname, n.cores = 1)
fl_out <- fastLink(dfA[subset_out$dfA.block == 1,], dfB[subset_out$dfB.block == 1,],
varnames = c("firstname", "lastname", "streetname", "birthyear"), n.cores = 1)
}
}
