% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{general_confusion_results}
\alias{general_confusion_results}
\title{General Confusion Table and Errors}
\usage{
general_confusion_results(yhat, yfac, proportions_scaled_by_column = FALSE)
}
\arguments{
\item{yhat}{The factor predictions}

\item{yfac}{The true factor responses}

\item{proportions_scaled_by_column}{When returning the proportion table, scale by column? Default is \code{FALSE} to keep the probabilities 
unconditional to provide the same values as the function \code{confusion_results}. Set to \code{TRUE}
to understand error probabilities by prediction bucket.}
}
\value{
A list of raw results
}
\description{
Provides a confusion table and error metrics for general factor vectors.
There is no need for the same levels in the two vectors.
}
\examples{
library(MASS); data(Pima.te)
ybin = as.numeric(Pima.te$type == "Yes")
flr = fast_logistic_regression(
  Xmm = model.matrix(~ . - type, Pima.te), 
  ybin = ybin
)
phat = predict(flr, model.matrix(~ . - type, Pima.te))
yhat = array(NA, length(ybin))
yhat[phat <= 1/3] = "no"
yhat[phat >= 2/3] = "yes"
yhat[is.na(yhat)] = "maybe"
general_confusion_results(factor(yhat, levels = c("no", "yes", "maybe")), factor(ybin)) 
#you want the "no" to align with 0, the "yes" to align with 1 and the "maybe" to be 
#last to align with nothing
}
