% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{fmm_to_mat}
\alias{fmm_to_mat}
\title{Convert Matrix Market File to Matrix}
\usage{
fmm_to_mat(filename)
}
\arguments{
\item{filename}{The name of the input Matrix Market file to be read.}
}
\value{
A matrix containing the data read from the Matrix Market file.
}
\description{
This function reads a Matrix Market file and converts it to a
matrix in R.
}
\examples{
# Create
sample_mat <- matrix(c(1, 2, 3, 4), nrow = 2)
temp_file_mat <- tempfile(fileext = ".mtx")
write_fmm(sample_mat, temp_file_mat)
# Read
mat <- fmm_to_mat(temp_file_mat)
}
