% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAN.R
\name{GANLearner_from_learners}
\alias{GANLearner_from_learners}
\title{GAN Learner from learners}
\usage{
GANLearner_from_learners(
  gen_learn,
  crit_learn,
  switcher = NULL,
  weights_gen = NULL,
  gen_first = FALSE,
  switch_eval = TRUE,
  show_img = TRUE,
  clip = NULL,
  cbs = NULL,
  metrics = NULL,
  loss_func = NULL,
  opt_func = Adam(),
  lr = 0.001,
  splitter = trainable_params(),
  path = NULL,
  model_dir = "models",
  wd = NULL,
  wd_bn_bias = FALSE,
  train_bn = TRUE,
  moms = list(0.95, 0.85, 0.95)
)
}
\arguments{
\item{gen_learn}{generator learner}

\item{crit_learn}{discriminator learner}

\item{switcher}{switcher}

\item{weights_gen}{weights generator}

\item{gen_first}{generator first}

\item{switch_eval}{switch evaluation}

\item{show_img}{show image or not}

\item{clip}{clip value}

\item{cbs}{Cbs is one or a list of Callbacks to pass to the Learner.}

\item{metrics}{It is an optional list of metrics, that can be either functions or Metrics.}

\item{loss_func}{loss function}

\item{opt_func}{The function used to create the optimizer}

\item{lr}{learning rate}

\item{splitter}{It is a function that takes self.model and returns a list of parameter groups (or just one parameter group if there are no different parameter groups).}

\item{path}{The folder where to work}

\item{model_dir}{Path and model_dir are used to save and/or load models.}

\item{wd}{It is the default weight decay used when training the model.}

\item{wd_bn_bias}{It controls if weight decay is applied to BatchNorm layers and bias.}

\item{train_bn}{It controls if BatchNorm layers are trained even when they are supposed to be frozen according to the splitter.}

\item{moms}{The default momentums used in Learner$fit_one_cycle.}
}
\value{
None
}
\description{
Create a GAN from `learn_gen` and `learn_crit`.
}
