% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_estimation.R
\name{variance_arma}
\alias{variance_arma}
\alias{variance.arma}
\title{Variance estimation for ARMA model with change points}
\usage{
variance_arma(data, p, q, max_order = p * q)

variance.arma(data, p, q, max_order = p * q)
}
\arguments{
\item{data}{A one-column matrix or a vector.}

\item{p}{The order of the autoregressive part.}

\item{q}{The order of the moving average part.}

\item{max_order}{The maximum order of the AR model to consider.}
}
\value{
A numeric value representing the variance.
}
\description{
Estimate the variance for each block and then take the average.
}
\examples{
set.seed(1)
n <- 300
w <- rnorm(n + 3, 0, 10)
x <- rep(0, n + 3)
for (i in 1:200) {
  x[i + 3] <- 0.1 * x[i + 2] - 0.3 * x[i + 1] + 0.1 * x[i] +
    0.1 * w[i + 2] + 0.5 * w[i + 1] + w[i + 3]
}
for (i in 201:n) {
  x[i + 3] <- 0.3 * x[i + 2] + 0.1 * x[i + 1] - 0.3 * x[i] -
    0.6 * w[i + 2] - 0.1 * w[i + 1] + w[i + 3]
}
(result <- variance.arma(x[-seq_len(3)], p = 3, q = 2))
}
