% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd.ts}
\alias{fastcpd.ts}
\alias{fastcpd_ts}
\title{Find change points efficiently in time series data}
\usage{
fastcpd.ts(data, family = NULL, order = c(0, 0, 0), ...)

fastcpd_ts(data, family = NULL, order = c(0, 0, 0), ...)
}
\arguments{
\item{data}{A numeric vector, a matrix, a data frame or a time series object.}

\item{family}{A character string specifying the family of the time series.
The value should be one of \code{"ar"}, \code{"var"}, \code{"arima"} or
\code{"garch"}.}

\item{order}{A positive integer or a vector of length less than four
specifying the order of the time series. Possible combinations with
\code{family} are:
\itemize{
\item ar, NUMERIC(1): AR(p) model using linear regression.
\item ar, NUMERIC(3): ARIMA(p, 0, 0) model using \code{forecast::Arima}, where
\code{p} is the first element of the vector.
\item var, NUMERIC(1): VAR(p) model using linear regression.
\item ma, NUMERIC(1): MA(q) model using \code{forecast::Arima}.
\item ma, NUMERIC(3): ARIMA(0, 0, q) model using \code{forecast::Arima}, where
\code{q} is the third element of the vector.
\item arima, NUMERIC(3): ARIMA(p, d, q) model using \code{forecast::Arima}.
\item garch, NUMERIC(2): GARCH(p, q) model using \code{tseries::garch}.
}}

\item{...}{Other arguments passed to \code{\link{fastcpd}}, for example,
\code{segment_count}. One special argument can be passed here is
\code{include.mean}, which is a logical value indicating whether the
mean should be included in the model. The default value is \code{TRUE}.}
}
\value{
A class \code{fastcpd} object.
}
\description{
\code{fastcpd_ts} is a wrapper function for \code{fastcpd} to find
change points in time series data. The function is similar to \code{fastcpd}
except that the data is a time series data and the family is one of
\code{"ar"}, \code{"var"}, \code{"arima"} or \code{"garch"}.
}
\examples{
\donttest{
set.seed(1)
n <- 600
x <- rep(0, n + 1)
for (i in 1:300) {
  x[i + 1] <- 0.8 * x[i] + rnorm(1, 0, 2)
}
for (i in 301:n) {
  x[i + 1] <- 0.1 * x[i] + rnorm(1, 0, 2)
}
result <- fastcpd.ts(
  x[1 + seq_len(n)],
  "ar",
  c(1, 0, 0),
  include.mean = FALSE,
  trim = 0,
  beta = (1 + 1 + 1) * log(n) / 2 * 3
)
summary(result)
plot(result)
}
}
