% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{get_model_engine_names}
\alias{get_model_engine_names}
\title{Get Model Engine Names}
\usage{
get_model_engine_names(models)
}
\arguments{
\item{models}{A nested list of model workflows. Each inner list should contain model objects from which a fitted model can be extracted using \code{tune::extract_fit_parsnip}.}
}
\value{
A named character vector where the names correspond to algorithm names (e.g., \code{"rand_forest"}, \code{"logistic_reg"}) and the values correspond to the associated engine names (e.g., \code{"ranger"}, \code{"glm"}).
}
\description{
Extracts and returns a named vector mapping algorithm names to engine names from a nested list of model workflows.
}
\details{
The function iterates over a nested list of model workflows and, for each workflow, attempts to extract the fitted model object using \code{tune::extract_fit_parsnip}. If successful, it retrieves the algorithm name from the first element of the class attribute of the model specification and the engine name from the specification. The results are combined into a named vector.
}
