% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_id.R
\name{group_id}
\alias{group_id}
\alias{add_group_id}
\alias{add_group_id.data.frame}
\alias{row_id}
\alias{row_id.GRP}
\alias{add_row_id}
\alias{add_row_id.data.frame}
\title{Fast group and row IDs}
\usage{
group_id(data, order = TRUE, ascending = TRUE, as_qg = FALSE)

add_group_id(
  data,
  ...,
  order = TRUE,
  ascending = TRUE,
  .by = NULL,
  .cols = NULL,
  .name = NULL,
  as_qg = FALSE
)

\method{add_group_id}{data.frame}(
  data,
  ...,
  order = df_group_by_order_default(data),
  ascending = TRUE,
  .by = NULL,
  .cols = NULL,
  .name = NULL,
  as_qg = FALSE
)

row_id(data, ascending = TRUE)

\method{row_id}{GRP}(data, ascending = TRUE)

add_row_id(data, ..., ascending = TRUE, .by = NULL, .cols = NULL, .name = NULL)

\method{add_row_id}{data.frame}(data, ..., ascending = TRUE, .by = NULL, .cols = NULL, .name = NULL)
}
\arguments{
\item{data}{A data frame or vector.}

\item{order}{Should the groups be ordered?
\bold{THE PHYSICAL ORDER OF THE DATA IS NOT CHANGED.} \cr
When order is \code{TRUE} (the default) the group IDs will be
ordered but not sorted.\cr

If \code{FALSE} the order of the group IDs will be based on first appearance.}

\item{ascending}{Should the group order be ascending or descending?
The default is \code{TRUE}. \cr
For \code{row_id()} this determines if the row IDs are increasing or decreasing. \cr
\bold{NOTE} - When \code{order = FALSE}, the \code{ascending} argument is
ignored. This is something that will be fixed in a later version.}

\item{as_qg}{Should the group IDs be returned as a
collapse "qG" class? The default (\code{FALSE}) always returns
an integer vector.}

\item{...}{Additional groups using tidy \code{data-masking} rules. \cr
To specify groups using \code{tidyselect}, simply use the \code{.by} argument.}

\item{.by}{Alternative way of supplying groups using \code{tidyselect} notation.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{.name}{Name of the added ID column which should be a
character vector of length 1.
If \code{.name = NULL} (the default),
\code{add_group_id()} will add a column named "group_id",
and if one already exists, a unique name will be used.}
}
\value{
An integer vector.
}
\description{
These are tidy-based functions for calculating group IDs and row IDs. \cr
\itemize{
\item \code{group_id()} returns an integer vector of group IDs
the same size as the data.
\item \code{row_id()} returns an integer vector of row IDs.
}

The \code{add_} variants add a column of group IDs/row IDs.
}
