% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conflicts.R
\name{fastverse_conflicts}
\alias{fastverse_conflicts}
\title{Conflicts between the fastverse and other packages}
\usage{
fastverse_conflicts(pkg = fastverse_packages())
}
\arguments{
\item{pkg}{character. A vector of packages to check conflicts for. The default is all \emph{fastverse} packages.}
}
\value{
An object of class 'fastverse_conflicts': A named list of character vectors where the names are the conflicted objects, and the 
content are the names of the package namespaces containing the object, in the order they appear on the \code{\link{search}} path.
}
\description{
This function lists all the conflicts among \emph{fastverse} packages and between \emph{fastverse} packages and other attached packages.
It can also be used to check conflicts for any other attached packages.
}
\details{
There are 2 internal conflict in the core \emph{fastverse} which are not displayed by \code{fastverse_conflicts()}:
\itemize{
\item \code{collapse::funique} masks \code{kit::funique}. If both packages are detached, \emph{collapse} is attached after \emph{kit}. In general, the 
\emph{collapse} version is often faster on data frames and supports unique rows on selected columns, but only preserves the first-match appearance order of 
character data (unique values for numeric columns are determined using a sort-based method). 
An option \code{sort = TRUE} lets \code{collapse::funique} return sorted unique values (for both character and numeric data). 
The \emph{kit} version is generally faster for vectors and sometimes for data frames, and also supports matrices. 
It is a full hash-table based implementation that always preserves the first-match appearance order of data.   

\item \code{matrixStats::count} masks \code{kit::count}. The \emph{matrixStats} version is more flexible, supporting restricted search and missing value removal. The \emph{kit} version is nearly twice as fast. 
}
}
\examples{
# Check conflicts between fastverse packages and all attached packages
fastverse_conflicts()

# Check conflicts among all attached packages
fastverse_conflicts(rm_stub(search()[-1], "package:"))
}
\seealso{
\code{\link{fastverse}}
}
