% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/children.R
\name{fastverse_child}
\alias{fastverse_child}
\title{Create a new (descendant) verse of packages}
\usage{
fastverse_child(
  name,
  title,
  pkg,
  maintainer,
  version = "0.1.0",
  dir = ".",
  theme = c("fastverse", "tidyverse"),
  install = TRUE,
  keep.dir = TRUE,
  ...
)
}
\arguments{
\item{name}{character. The name of the child-verse e.g. 'myMLverse'.}

\item{title}{character. The title of the child-verse e.g. 'My Machine Learning Verse'.}

\item{pkg}{character. A vector of core packages for the new verse.}

\item{maintainer}{character. A quoted \code{\link{person}} statement giving the package maintainer. 
If you do not intend to substantially modify the code of the resulting source package, \code{role = "cre"} is appropriate. See Examples.}

\item{version}{character. A quoted version number for the new package.}

\item{dir}{character. The directory in which a source directory dir/name for the package will be created.}

\item{theme}{character. Set the colour-theme for text printed to the console. The options are \code{"fastverse"} or \code{"tidyverse"}.}

\item{install}{logical. \code{TRUE} installs the package using \code{install.packages(dir/name, repos = NULL, type = "source", ...)}.}

\item{keep.dir}{logical. \code{FALSE} will remove the source directory (dir/name) again after installation.}

\item{\dots}{further arguments to \code{\link{install.packages}}.}
}
\value{
\code{fastverse_child} returns \code{NULL} invisibly.
}
\description{
Creates and installs a fully customizable descendant verse of packages that is itself extensible and inherits 90\%
of the functionality of the \emph{fastverse} package.
}
\details{
This function creates and installs a source package according to the users specification. 
For that it downloads the 'child' branch of the \href{https://github.com/fastverse/fastverse}{GitHub repository}, which 
was specifically set up to produce a new verse, unzips it into a source directory, and substitutes the user inputs into the files. 
The package is then installed from source, and (optionally) the source directory is removed again. 

\emph{fastverse} children inherit 90\% of the functionality of the \emph{fastverse} package: they are not permanently globally extensible and can not bear children themselves, 
but can be configured for projects (using a \code{.name} config file) and extended in the session.
Use of this function requires an internet connection but no additional R packages (like \code{devtools}, \code{remotes} or \code{roxygen2}).
}
\examples{
\dontrun{

fastverse_child(
  name = "tsverse", 
  title = "Time Series Package Verse", 
  pkg = c("xts", "roll", "zoo", "tsbox", "urca", "tseries", "tsutils", "forecast"), 
  maintainer = 'person("GivenName", "FamilyName", role = "cre", email = "your@email.com")',
  dir = "C:/Users/.../Documents", 
  theme = "tidyverse")
}
}
\seealso{
\code{\link{fastverse_extend}}, \code{\link{fastverse}}
}
