% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{rlikert}
\alias{rlikert}
\title{Random Likert distribution}
\usage{
rlikert(n, prob, labels = names(prob))
}
\arguments{
\item{n}{the number of observations}

\item{prob}{a vector of probabilities or counts; if named, the output is a factor}

\item{labels}{a vector of values, defaults to names(prob) or 1:length(prob), if numeric, the output is numeric}
}
\value{
a vector sampled from a likert distribution with the specified parameters
}
\description{
Random Likert distribution
}
\examples{
# no names or labels returns integer vector of values 1:length(prob)
prob <- c(.1, .2, .4, .2, .1)
rlikert(10, prob)

# named prob returns factor 
prob <- c(A = 10, B = 20, C = 30)
rlikert(10, prob)

# specify labels if prob not named and not 1:length(prob)
labels <- -2:2 
prob <- rep(1, length(labels)) # uniform probability
rlikert(10, prob, labels)
}
