% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entails_equiv.R
\name{\%entails\%}
\alias{\%entails\%}
\title{Entailment between implication sets}
\usage{
imps \%entails\% imps2
}
\arguments{
\item{imps}{(\code{ImplicationSet}) A set of implications.}

\item{imps2}{(\code{ImplicationSet}) A set of implications which
is tested to check if it follows semantically from \code{imps}.}
}
\value{
A logical vector, where element k is \code{TRUE} if the
k-th implication in \code{imps2} follows from \code{imps}.
}
\description{
Entailment between implication sets
}
\examples{
fc <- FormalContext$new(planets)
fc$find_implications()
imps <- fc$implications[1:4]$clone()
imps2 <- fc$implications[3:6]$clone()
imps \%entails\% imps2
}
