% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_fct.R
\name{fct_rename_levels}
\alias{fct_rename_levels}
\title{Rename Factor Levels Using Data Frame Mapping}
\usage{
fct_rename_levels(factor_vec, mapping_df)
}
\arguments{
\item{factor_vec}{A factor vector to modify.}

\item{mapping_df}{A data frame with two columns: 'old' and 'new', representing old and new level names.}
}
\value{
A factor vector with levels renamed.
}
\description{
Renames the levels of a factor vector based on a mapping provided in a data frame.
}
\examples{
# Example factor vector
factor_vec <- factor(c('A', 'B', 'C'))

# Mapping data frame
mapping_df <- data.frame(old = c('A', 'B'), new = c('Alpha', 'Beta'))

# Rename levels
fct_rename_levels(factor_vec, mapping_df)
}
\author{
Kai Guo
}
