
<!-- README.md is generated from README.Rmd. Please edit that file -->

<!--
# fda.usc
README.md is generated from README.Rmd. Please edit that file 
#[![Travis-CI Build Status](https://api.travis-ci.org/maierhofert/classiFunc.svg?branch=master)](https://travis-ci.org/maierhofert/classiFunc)
#[![packageversion](https://img.shields.io/badge/Package%20version-0.1.1-orange.svg?style=flat-square)](https://CRAN.R-project.org/package=classiFunc)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/fda.usc)](https://cran.r-project.org/package=fda.usc)
[![](https://cranlogs.r-pkg.org/badges/fda.usc)](https://cran.r-project.org/package=fda.usc)
# [![Licence](https://img.shields.io/badge/licence-GPL--3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0.en.html)
Incluir reference card
[![Travis-CI Build Status](https://api.travis-ci.org/moviedo5/fda.usc.svg?branch=master)](https://travis-ci.org/moviedo5/fda.usc)
## fda.usc: Functional Data Analysis and Utilities for Statistical Computing

<img src="inst/figures/fda.usc.png" align="right" height="300"/>
-->

# fda.usc: Functional Data Analysis and Utilities for Statistical Computing <img src="inst/figures/fda.usc.png" align="right" width="140" />

[![CRAN\_Status\_Badge](https://www.r-pkg.org/badges/version/fda.usc)](https://cran.r-project.org/package=fda.usc)
[![Licence](https://img.shields.io/badge/licence-GPL--2-blue.svg)](https://www.gnu.org/licenses/gpl-2.0.en.html)
[![](https://cranlogs.r-pkg.org/badges/fda.usc)](https://cran.r-project.org/package=fda.usc)

## Package overview

<!--The **fda.usc** package implements methods  for exploratory and descriptive analysis of functional data such as depth measurements, atypical curves detection, regression models, supervised classification, unsupervised classification and functional analysis of variance.
-->

**fda.usc** package carries out exploratory and descriptive analysis of
functional data exploring its most important features such as depth
measurements or functional outliers detection, among others. It also
helps to explain and model the relationship between a dependent variable
and independent (regression models) and make predictions. Methods for
supervised or unsupervised classification of a set of functional data
regarding a feature of the data are also included. It can perform
functional ANOVA, hypothesis testing, functional response models and
many others.

## Installation

You can install the current fda.usc version from CRAN with:

``` r
install.packages("fda.usc")
```

or the latest patched version from Github with:

``` r
library(devtools)
devtools::install_github("moviedo5/fda.usc")
```

## Issues & Feature Requests

For issues, bugs, feature requests etc. please use the [Github
Issues](https://github.com/moviedo5/fda.usc/issues). Input is always
welcome.

## Documentation

A hands on introduction to  can be found in the reference
[vignette](https://www.jstatsoft.org/index.php/jss/article/view/v051i04/v51i04.pdf).

Details on specific functions are in the [reference
manual](https://cran.r-project.org/package=fda.usc/fda.usc.pdf).

Cheatsheet [fda.usc reference
card](https://zenodo.org/record/3386752/files/RefCard_fda.usc_v1.pdf?download=1).

## References

Febrero-Bande, M. and Oviedo de la Fuente, M. (2012). Statistical
Computing in Functional Data Analysis: The R Package fda.usc. *Journal
of Statistical Software*, 51(4):1-28.
<http://www.jstatsoft.org/v51/i04/>

<!--
library(roxygen2)
setwd("C:/Users/moviedo/github/fda.usc_2.0.2/")
getwd()
pkgbuild::compile_dll()
roxygenize()
devtools::document()

library(devtools)
# devtools::install_github("moviedo5/fda.usc.devel",auth_user="moviedo5")

R CMD build fda.usc_2.0.2
R CMD check fda.usc_2.0.2.tar.gz --as-cran
R CMD INSTALL fda.usc_2.0.2.tar.gz --build

Manuel Oviedo PhD thesis [Advances in functional regression and classification models](http://hdl.handle.net/10347/18236)
-->


-->

<!-- ```{r example} -->

<!-- ## basic example code -->

<!-- 
<img src="inst/figures/baseplot.png" height="300"/>
-->
